#include "StdAfx.h"
#include "CLS_MP4FileReader.h"

#define MP4_BEGIN_NO 1

CLS_MP4FileReader::CLS_MP4FileReader()
{
	
}

CLS_MP4FileReader::CLS_MP4FileReader( CString _strName )
{
	m_pMp4Handle = NULL;
	m_pMp4Handle = CLS_MP4Operation::Instance()->MP4_Open((td_char*)(LPCSTR)(LPCTSTR)_strName);
	if (m_pMp4Handle == NULL)
	{
		return ;
	}
	
	int iRet = CLS_MP4Operation::Instance()->MP4_GetFileHead(m_pMp4Handle, (S_FileHeader *)&m_FileHeader);
	if (iRet < 0)
	{
		return ;
	}
	m_bFileHeader = TRUE;
}

CLS_MP4FileReader::~CLS_MP4FileReader(void)
{
	if (m_pMp4Handle != NULL)
	{
		CLS_MP4Operation::Instance()->MP4_Close(m_pMp4Handle);
		m_pMp4Handle = NULL;
	}
}

int CLS_MP4FileReader::ReadFrame( char* _pReadBuffer, int _iBufferLen )
{
	if (_pReadBuffer == NULL)
	{
		return -1;
	}

	int iReturnLen = 0;
	int iRet = CLS_MP4Operation::Instance()->MP4_Read(m_pMp4Handle, _pReadBuffer, _iBufferLen);
	if (iRet >= 0)
	{
		FrameHeader* pHeadr = (FrameHeader*)_pReadBuffer;
		return pHeadr->uiSize;
	}

	CLS_MP4Operation::Instance()->MP4_Seek(m_pMp4Handle, MP4_BEGIN_NO, SEEK_ABSOLUTE); //һζʧܶλͷٶһ

	iRet = CLS_MP4Operation::Instance()->MP4_Read(m_pMp4Handle, _pReadBuffer, _iBufferLen);
	if (iRet >= 0)
	{
		FrameHeader* pHeadr = (FrameHeader*)_pReadBuffer;
		return pHeadr->uiSize;
	}

	return 0;
}
